/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.auiml.databeans.sfp;

import com.ibm.hsc.auiml.databeans.sfp.SFPBean;
import com.ibm.hsc.auiml.databeans.sfp.SFPException;
import com.ibm.hsc.common.util.Trace;
import com.ibm.hsc.websm.sfp.SelectServiceableEvent;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.p.pa.problem.PIProblem;
import com.ibm.hwmca.xfw.pa.util.ProblemDataDescriptor;
import com.ibm.ui.framework.Capabilities;
import com.ibm.ui.framework.ColumnDescriptor;
import com.ibm.ui.framework.IllegalUserDataException;
import com.ibm.ui.framework.ItemDescriptor;
import com.ibm.ui.framework.TaskSelectionEvent;
import com.ibm.ui.framework.TaskSelectionListener;
import com.ibm.ui.framework.UserTaskManager;
import java.util.ArrayList;
import java.util.List;

public class SFPServiceableEventManageProblemDataBean
extends SFPBean
implements TaskSelectionListener {
    private transient ItemDescriptor[] m_idProblemData;
    private transient ColumnDescriptor[] m_cdProblemDataStructure;
    private int[] m_iProblemDataSelection;
    private String problemKey;
    private ProblemDataDescriptor[] selectedData = new ProblemDataDescriptor[0];
    private int rowCount = 0;
    private boolean USE_TEST_DATA = false;
    private boolean hasPartitionMap = false;
    private boolean callHomeOK = true;
    private List problemData = null;
    private static final String TRACE_MASKD = "JSEVENTD";
    private static final String TRACE_MASKF = "JSEVENTF";
    private static final String TRACE_MASKT = "JSEVENTT";
    public static final String RESOURCE_NAME = "com.ibm.hsc.auiml.databeans.sfp.SFPServiceableEventManageProblemDataAuiml";
    public static final String PANEL_NAME = "ManageProblemDataPanel";
    public static final String TABLE_NAME = "ProblemData";

    public SFPServiceableEventManageProblemDataBean(String string, boolean bl, boolean bl2) throws SFPException {
        super(bl, bl2);
        this.problemKey = string;
        PIProblem pIProblem = SelectServiceableEvent.getProblem(string);
        if (pIProblem != null) {
            this.problemData = pIProblem.getProblemDataSet();
            this.callHomeOK = SelectServiceableEvent.callHomeEnabled(pIProblem);
        }
        this.USE_TEST_DATA = SelectServiceableEvent.USE_TEST_PROBLEM;
    }

    public String getProblemKey() {
        return this.problemKey;
    }

    public List getAllProblemDataDescriptors() {
        return this.problemData;
    }

    public ColumnDescriptor[] getProblemDataRowStructure() {
        return this.m_cdProblemDataStructure;
    }

    public int getProblemDataRowStatus() {
        return 3;
    }

    public int getProblemDataRowCount() {
        return 0;
    }

    public ItemDescriptor[] getProblemDataRowAt(int n) {
        return this.m_idProblemData;
    }

    public void setProblemDataRowAt(int n, ItemDescriptor[] itemDescriptorArray) throws IllegalUserDataException {
        this.m_idProblemData = itemDescriptorArray;
    }

    public int[] getProblemDataSelection() {
        return this.m_iProblemDataSelection;
    }

    public void setProblemDataSelection(int[] nArray) throws IllegalUserDataException {
        this.m_iProblemDataSelection = nArray;
    }

    public ProblemDataDescriptor[] getSelectedData() {
        return this.selectedData;
    }

    public Capabilities getCapabilities() {
        return null;
    }

    public void verifyChanges() throws IllegalUserDataException {
    }

    public void save() {
    }

    public void load() {
    }

    public void prepare() {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "->SFPServiceableEventManageProblemDataBean.prepare()");
        }
        try {
            while (true) {
                this.getUserTaskManager().removeRow(TABLE_NAME, 0);
            }
        }
        catch (Exception exception) {
            this.rowCount = 0;
            this.hasPartitionMap = false;
            ArrayList<ItemDescriptor[]> arrayList = new ArrayList<ItemDescriptor[]>();
            if (this.USE_TEST_DATA) {
                ItemDescriptor[] itemDescriptorArray = new ItemDescriptor[]{new ItemDescriptor("0", "Power Assembly Dump (TEST)")};
                itemDescriptorArray[0].setUserObject((Object)new ProblemDataDescriptor());
                arrayList.add(itemDescriptorArray);
                itemDescriptorArray = new ItemDescriptor[]{new ItemDescriptor("1", "Power Assembly EED (TEST)")};
                itemDescriptorArray[0].setUserObject((Object)new ProblemDataDescriptor());
                arrayList.add(itemDescriptorArray);
                itemDescriptorArray = new ItemDescriptor[]{new ItemDescriptor("2", "Partition map (TEST)")};
                itemDescriptorArray[0].setUserObject((Object)new ProblemDataDescriptor());
                arrayList.add(itemDescriptorArray);
            } else if (this.problemData != null) {
                int n = this.problemData.size();
                for (int i = 0; i < n; ++i) {
                    String string;
                    ProblemDataDescriptor problemDataDescriptor = (ProblemDataDescriptor)this.problemData.get(i);
                    if (2 <= Trace.LEVEL) {
                        Trace.trace(TRACE_MASKF, "SFPServiceableEventManageProblemDataBean.prepare() handling descriptor " + problemDataDescriptor);
                    }
                    if (problemDataDescriptor == null) continue;
                    if ("INIT_CALL_HOME_DATA_SET".equals(problemDataDescriptor.getType())) {
                        if (2 > Trace.LEVEL) continue;
                        Trace.trace(TRACE_MASKF, "SFPServiceableEventManageProblemDataBean.prepare() found zip file ");
                        continue;
                    }
                    LocalizableText localizableText = this.translateDataType(problemDataDescriptor);
                    ItemDescriptor[] itemDescriptorArray = new ItemDescriptor[1];
                    String string2 = "";
                    if (localizableText != null) {
                        string2 = localizableText.toString() + ": ";
                    }
                    if ((string = problemDataDescriptor.getName()).indexOf("/") > -1) {
                        int n2 = string.lastIndexOf("/");
                        string = string.substring(++n2);
                    }
                    string2 = string2 + string;
                    if (problemDataDescriptor.isInZip()) {
                        String string3 = problemDataDescriptor.getFileLocation();
                        if (string3.indexOf("/") > -1) {
                            int n3 = string3.lastIndexOf("/");
                            string3 = string3.substring(++n3);
                        }
                        string2 = string2 + " in " + string3;
                    }
                    itemDescriptorArray[0] = new ItemDescriptor("PD" + i, string2);
                    itemDescriptorArray[0].setUserObject((Object)problemDataDescriptor);
                    arrayList.add(itemDescriptorArray);
                }
            }
            this.rowCount = 0;
            for (int i = 0; i < arrayList.size(); ++i) {
                this.getUserTaskManager().addRow(TABLE_NAME, i, (ItemDescriptor[])arrayList.get(i));
                ++this.rowCount;
            }
            this.setButtonAndMenuStates();
            this.getUserTaskManager().addTaskSelectionListener((TaskSelectionListener)this, TABLE_NAME);
            this.setTitle();
            if (1 <= Trace.LEVEL) {
                Trace.trace(TRACE_MASKT, "<-SFPServiceableEventManageProblemDataBean.prepare()");
            }
            return;
        }
    }

    private LocalizableText translateDataType(ProblemDataDescriptor problemDataDescriptor) {
        String string = problemDataDescriptor.getType();
        string = string == null ? "UNKNOWN" : string;
        Object object = null;
        if (string.equals("SP_DUMP")) {
            object = new LocalizableText("com.ibm.hsc.common.bundles.SFPResourceBundle", "PROBLEM_DATA_SPD");
        } else if (string.equals("SMA_DUMP")) {
            object = new LocalizableText("com.ibm.hsc.common.bundles.SFPResourceBundle", "PROBLEM_DATA_SMAD");
        } else if (string.equals("POWER_DUMP")) {
            object = new LocalizableText("com.ibm.hsc.common.bundles.SFPResourceBundle", "PROBLEM_DATA_PAD");
        } else if (string.equals("PLATFORM_DUMP")) {
            object = new LocalizableText("com.ibm.hsc.common.bundles.SFPResourceBundle", "PROBLEM_DATA_PSD");
        } else if (string.equals("OS_EED")) {
            object = new LocalizableText("com.ibm.hsc.common.bundles.SFPResourceBundle", "PROBLEM_DATA_OSEED");
        } else if (string.equals("HPS_EED")) {
            object = new LocalizableText("com.ibm.hsc.common.bundles.SFPResourceBundle", "PROBLEM_DATA_HPSEED");
        } else if (string.equals("POWER_EED")) {
            object = new LocalizableText("com.ibm.hsc.common.bundles.SFPResourceBundle", "PROBLEM_DATA_PAEED");
        } else if (string.equals("HMC_EED")) {
            object = new LocalizableText("com.ibm.hsc.common.bundles.SFPResourceBundle", "PROBLEM_DATA_HMCEED");
        } else if (string.equals("SYS_EED")) {
            object = new LocalizableText("com.ibm.hsc.common.bundles.SFPResourceBundle", "PROBLEM_DATA_OSEED");
        } else if (string.equals("PARTITION_MAP")) {
            object = new LocalizableText("com.ibm.hsc.common.bundles.SFPResourceBundle", "PROBLEM_DATA_PM");
            this.hasPartitionMap = true;
        } else {
            object = string.equals("UNKNOWN") ? null : new LocalizableText(string);
        }
        return object;
    }

    public String getPanelName() {
        return PANEL_NAME;
    }

    public void selectionChanged(TaskSelectionEvent taskSelectionEvent) {
        int[] nArray;
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "->SFPServiceableEventManageProblemDataBean.selectionChanged()");
        }
        if ((nArray = this.getUserTaskManager().getSelectedRows(TABLE_NAME)) != null && nArray.length != 0) {
            this.selectedData = new ProblemDataDescriptor[nArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                int n = nArray[i];
                ItemDescriptor[] itemDescriptorArray = this.getUserTaskManager().getRow(TABLE_NAME, n);
                this.selectedData[i] = (ProblemDataDescriptor)itemDescriptorArray[0].getUserObject();
            }
        } else if (this.selectedData.length > 0) {
            this.selectedData = new ProblemDataDescriptor[0];
        }
        this.setButtonAndMenuStates();
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<-SFPServiceableEventManageProblemDataBean.selectionChanged()");
        }
    }

    private void setButtonAndMenuStates() {
        boolean bl;
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "->SFPServiceableEventManageProblemDataBean.setButtonAndMenuStates()");
        }
        UserTaskManager userTaskManager = this.getUserTaskManager();
        userTaskManager.setEnabled("SaveToDVD", this.rowCount > 0 && this.hasWriteAccess());
        ProblemDataDescriptor[] problemDataDescriptorArray = this.getSelectedData();
        boolean bl2 = bl = problemDataDescriptorArray != null && problemDataDescriptorArray.length > 0;
        if (3 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKD, "SFPServiceableEventManageProblemDataBean.setButtonAndMenuStates() table rowSelected is " + bl);
        }
        userTaskManager.setEnabled("CallHome", bl && this.hasWriteAccess() && this.callHomeOK);
        boolean bl3 = false;
        if (bl && this.hasPartitionMap && problemDataDescriptorArray != null) {
            for (int i = 0; !bl3 && i < problemDataDescriptorArray.length; ++i) {
                ProblemDataDescriptor problemDataDescriptor = problemDataDescriptorArray[i];
                if (problemDataDescriptor == null || problemDataDescriptor.getType() == null) continue;
                bl3 = "PARTITION_MAP".equals(problemDataDescriptor.getType());
            }
        }
        userTaskManager.setEnabled("ViewButton", bl3);
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<-SFPServiceableEventManageProblemDataBean.setButtonAndMenuStates()");
        }
    }
}

